/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.CustomDrawContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.WorldChangeEvent;
import Krasnodar.rockstarnew.systems.event.impl.network.ReceivePacketEvent;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.PreHudRenderEvent;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.render.Utils;
import Krasnodar.rockstarnew.utility.time.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import lombok.Generated;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_2440;
import net.minecraft.class_2530;
import net.minecraft.class_2537;
import net.minecraft.class_2538;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

@ModuleInfo(name="Trap ESP", category=ModuleCategory.VISUALS)
public class TrapESP
extends BaseModule {
    private volatile List<Trap> traps = Collections.emptyList();
    private final Timer updateTimer = new Timer();
    private final Deque<class_2338> scanQueue = new ConcurrentLinkedDeque<class_2338>();
    private final Set<class_2338> enqueuedColumns = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Long, Trap> detectedTraps = new ConcurrentHashMap<Long, Trap>();
    private static final long SCAN_INTERVAL_MS = 5000L;
    private static final int SCAN_RADIUS = 64;
    private static final int COLUMNS_PER_TICK = 96;
    private static final int MAX_TRAP_DEPTH = 24;
    private static final int MIN_TRAP_DEPTH = 5;
    private final class_2248[] REGION_BLOCKS = new class_2248[]{class_2246.field_10085, class_2246.field_10205, class_2246.field_10201, class_2246.field_10234, class_2246.field_10442, class_2246.field_10013};
    private final EventListener<ClientPlayerTickEvent> onTick = event -> {
        if (TrapESP.mc.field_1724 != null && TrapESP.mc.field_1687 != null) {
            class_2338 columnBase;
            if (this.updateTimer.finished(5000L) && this.scanQueue.isEmpty()) {
                this.enqueueFullScan();
                this.updateTimer.reset();
            }
            int processed = 0;
            long timeBudgetNs = 2000000L;
            long startNs = System.nanoTime();
            while (processed < 96 && (columnBase = this.scanQueue.poll()) != null) {
                this.enqueuedColumns.remove(columnBase);
                ++processed;
                Trap t = this.scanColumnForTrap(columnBase);
                long key = TrapESP.packXZ(columnBase.method_10263(), columnBase.method_10260());
                if (t != null) {
                    this.detectedTraps.put(key, t);
                } else {
                    this.detectedTraps.remove(key);
                }
                if (System.nanoTime() - startNs <= timeBudgetNs) continue;
                break;
            }
            this.traps = new ArrayList<Trap>(this.detectedTraps.values());
        }
    };
    private final EventListener<ReceivePacketEvent> onPacket = event -> {
        if (TrapESP.mc.field_1724 != null && TrapESP.mc.field_1687 != null) {
            try {
                class_2672 wrapper;
                class_2596<?> packet = event.getPacket();
                if (packet instanceof class_2672) {
                    wrapper = (class_2672)packet;
                    this.enqueueChunk(new class_1923(wrapper.method_11523(), wrapper.method_11524()));
                }
                if (packet instanceof class_2637) {
                    wrapper = (class_2637)packet;
                    wrapper.method_30621((posx, state) -> this.enqueueColumn(posx.method_10263(), posx.method_10260()));
                }
                if (packet instanceof class_2626) {
                    wrapper = (class_2626)packet;
                    class_2338 pos = wrapper.method_11309();
                    this.enqueueColumn(pos.method_10263(), pos.method_10260());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    };
    private final EventListener<WorldChangeEvent> onWorldChange = event -> this.reset();
    private final EventListener<PreHudRenderEvent> onHud = ev -> {
        CustomDrawContext ctx = ev.getContext();
        class_4587 ms = ctx.method_51448();
        Font font = Fonts.MEDIUM.getFont(9.0f);
        int fontHeight = (int)font.height();
        for (Trap trap : this.traps) {
            class_241 screen = Utils.worldToScreen(trap.pos.method_46558().method_1031(0.0, 0.5, 0.0));
            if (screen == null) continue;
            String l1 = Localizator.translate("modules.trap_esp.label");
            String l2 = Localizator.translate("modules.trap_esp.depth", trap.depth);
            String l3 = trap.hasPrivate ? Localizator.translate("modules.trap_esp.private") : Localizator.translate("modules.trap_esp.no_private");
            int iconSize = 9;
            int textPadding = 6;
            int totalWidth = (int)(font.width(l2) + (float)textPadding);
            float titleWidth = font.width(l1) + 6.0f + (float)iconSize + 2.0f;
            float miniHeight = fontHeight * 2;
            float height = miniHeight * 3.0f;
            ctx.pushMatrix();
            ms.method_46416(screen.field_1343, screen.field_1342 - height, 0.0f);
            ctx.drawRect(-titleWidth / 2.0f, 0.0f, titleWidth, miniHeight, ColorRGBA.BLACK.withAlpha(150.0f));
            ctx.drawText(font, l1, -titleWidth / 2.0f + (float)iconSize + 5.0f, 3.0f, Colors.WHITE);
            ctx.drawTexture(Rockstar.id("icons/trap.png"), -titleWidth / 2.0f + 2.0f, (float)fontHeight - (float)iconSize / 2.0f, iconSize, iconSize, Colors.WHITE);
            ctx.drawRect((float)(-totalWidth) / 2.0f, miniHeight, totalWidth, miniHeight, ColorRGBA.BLACK.withAlpha(150.0f));
            ctx.drawText(font, l2, (float)(-totalWidth) / 2.0f + 2.0f, miniHeight + 3.0f, Colors.WHITE.withAlpha(200.0f));
            ctx.drawRect(-(font.width(l3) + 6.0f) / 2.0f, miniHeight * 2.0f, font.width(l3) + 6.0f, miniHeight, ColorRGBA.BLACK.withAlpha(150.0f));
            ctx.drawText(font, l3, -font.width(l3) / 2.0f, miniHeight * 2.0f + 3.0f, Colors.WHITE.withAlpha(200.0f));
            ctx.popMatrix();
        }
    };

    @Override
    public void onDisable() {
        this.reset();
        super.onDisable();
    }

    @Override
    public void onEnable() {
        this.reset();
        this.enqueueFullScan();
        super.onEnable();
    }

    public void reset() {
        this.scanQueue.clear();
        this.enqueuedColumns.clear();
        this.detectedTraps.clear();
        this.traps = Collections.emptyList();
        this.updateTimer.reset();
    }

    private void enqueueFullScan() {
        if (TrapESP.mc.field_1724 != null) {
            class_2338 playerPos = TrapESP.mc.field_1724.method_24515();
            ArrayList<class_2338> cols = new ArrayList<class_2338>(16641);
            for (int dx = -64; dx <= 64; ++dx) {
                for (int dz = -64; dz <= 64; ++dz) {
                    class_2338 col = new class_2338(playerPos.method_10263() + dx, playerPos.method_10264(), playerPos.method_10260() + dz);
                    if (!this.enqueuedColumns.add(col)) continue;
                    cols.add(col);
                }
            }
            cols.sort(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)playerPos)));
            this.scanQueue.addAll(cols);
        }
    }

    private void enqueueChunk(class_1923 chunkPos) {
        if (TrapESP.mc.field_1724 != null) {
            int baseY = TrapESP.mc.field_1724.method_24515().method_10264();
            int startX = chunkPos.method_8326();
            int startZ = chunkPos.method_8328();
            for (int x = startX; x < startX + 16; ++x) {
                for (int z = startZ; z < startZ + 16; ++z) {
                    class_2338 col = new class_2338(x, baseY, z);
                    if (!this.enqueuedColumns.add(col)) continue;
                    this.scanQueue.add(col);
                }
            }
        }
    }

    private void enqueueColumn(int x, int z) {
        int baseY;
        class_2338 pos;
        if (TrapESP.mc.field_1724 != null && this.enqueuedColumns.add(pos = new class_2338(x, baseY = TrapESP.mc.field_1724.method_24515().method_10264(), z))) {
            this.scanQueue.add(pos);
        }
    }

    private Trap scanColumnForTrap(class_2338 columnBase) {
        if (TrapESP.mc.field_1724 != null && TrapESP.mc.field_1687 != null) {
            int baseY = columnBase.method_10264();
            for (int dy = 20; dy >= -20; --dy) {
                class_2338 bottom;
                class_2680 bottomState;
                class_2338 start = new class_2338(columnBase.method_10263(), baseY + dy, columnBase.method_10260());
                int depth = 0;
                boolean inShaft = false;
                for (int i = 0; i < 24; ++i) {
                    class_2338 pos = start.method_10087(i);
                    class_2680 state = TrapESP.mc.field_1687.method_8320(pos);
                    if (state.method_26215() && TrapESP.mc.field_1687.method_8316(pos).method_15769()) {
                        int walls = 0;
                        for (class_2350 dir : class_2350.class_2353.field_11062) {
                            class_2338 side = pos.method_10093(dir);
                            class_2680 sideState = TrapESP.mc.field_1687.method_8320(side);
                            if (sideState.method_26215() || sideState.method_26220((class_1922)TrapESP.mc.field_1687, side).method_1110()) continue;
                            ++walls;
                        }
                        if (walls < 4) {
                            if (!inShaft) continue;
                            break;
                        }
                        inShaft = true;
                        ++depth;
                        continue;
                    }
                    if (inShaft) break;
                }
                if (depth < 5 || (bottomState = TrapESP.mc.field_1687.method_8320(bottom = start.method_10087(depth))).method_26215() || bottomState.method_26220((class_1922)TrapESP.mc.field_1687, bottom).method_1110()) continue;
                boolean flagged = this.hasNearbyIndicatorsOrValuables(start, 6);
                return new Trap(start, depth, flagged);
            }
            return null;
        }
        return null;
    }

    private boolean hasNearbyIndicatorsOrValuables(class_2338 center, int radius) {
        if (TrapESP.mc.field_1724 != null && TrapESP.mc.field_1687 != null) {
            class_2338 min = center.method_10069(-radius, -radius, -radius);
            class_2338 max = center.method_10069(radius, radius, radius);
            for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
                class_2680 state = TrapESP.mc.field_1687.method_8320(pos);
                if (state.method_26215()) continue;
                if (state.method_26204() instanceof class_2530 || state.method_26204() instanceof class_2440 || state.method_26204() instanceof class_2538 || state.method_26204() instanceof class_2537 || state.method_26204() instanceof class_2377 || state.method_26204() instanceof class_2281) {
                    return true;
                }
                class_2248 block = state.method_26204();
                for (class_2248 region : this.REGION_BLOCKS) {
                    if (block != region) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static long packXZ(int x, int z) {
        return (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
    }

    static class Trap {
        class_2338 pos;
        int depth;
        boolean hasPrivate;

        @Generated
        public Trap(class_2338 pos, int depth, boolean hasPrivate) {
            this.pos = pos;
            this.depth = depth;
            this.hasPrivate = hasPrivate;
        }
    }
}

